/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.ccm.Containers.Plugins;

import org.objectweb.ccm.Containers.ActivationController;
import org.objectweb.ccm.Containers.ActivationCoordinator;
import org.objectweb.ccm.Containers.CallController;
import org.objectweb.ccm.Containers.CallCoordinator;
import org.objectweb.ccm.Containers.ConfigurationFailed;
import org.objectweb.ccm.Containers.CreationFailed;
import org.objectweb.ccm.Containers.HomeNotFound;
import org.objectweb.ccm.Containers.PCAPolicy;
import org.objectweb.ccm.Containers.PropertySet;
import org.objectweb.ccm.Containers.SystemConfiguration;
import org.objectweb.ccm.Containers.SystemHome;
import org.objectweb.ccm.Containers.SystemHomeFinder;
import org.objectweb.ccm.util.Table;
import org.omg.CORBA.LocalObject;

public class PortSpecificConfiguration
extends LocalObject
implements SystemConfiguration {
    protected Table call_coordinator_sh_ = new Table();
    protected Table call_controllers_sh_ = new Table();
    protected Table call_coordinator_ps_ = new Table();
    protected Table call_controllers_ps_ = new Table();
    protected Table act_coordinator_sh_ = new Table();
    protected Table act_controllers_sh_ = new Table();
    protected Table act_coordinator_ps_ = new Table();
    protected Table act_controllers_ps_ = new Table();
    protected String[] policies_ = new String[0];
    protected SystemConfiguration parent_configuration_ = null;
    protected String the_component_base_uid_ = "";
    protected String the_component_version_ = "1.0";

    protected String getCallCoordinatorSystemHome(String uid) {
        return (String)this.call_coordinator_sh_.get((Object)uid);
    }

    protected PropertySet getCallCoordinatorPropertySet(String uid) {
        return (PropertySet)this.call_coordinator_ps_.get((Object)uid);
    }

    protected String[] getCallControllersSystemHome(String uid) {
        return (String[])this.call_controllers_sh_.get((Object)uid);
    }

    protected PropertySet[] getCallControllersPropertySet(String uid) {
        return (PropertySet[])this.call_controllers_ps_.get((Object)uid);
    }

    protected String getActCoordinatorSystemHome(String uid) {
        return (String)this.act_coordinator_sh_.get((Object)uid);
    }

    protected PropertySet getActCoordinatorPropertySet(String uid) {
        return (PropertySet)this.act_coordinator_ps_.get((Object)uid);
    }

    protected String[] getActControllersSystemHome(String uid) {
        return (String[])this.act_controllers_sh_.get((Object)uid);
    }

    protected PropertySet[] getActControllersPropertySet(String uid) {
        return (PropertySet[])this.act_controllers_ps_.get((Object)uid);
    }

    protected String[] getPCAPolicies() {
        return this.policies_;
    }

    public void setComponentUId(String comp_uid) {
        int idx = comp_uid.lastIndexOf(58);
        this.the_component_base_uid_ = comp_uid.substring(0, idx);
        this.the_component_version_ = comp_uid.substring(idx + 1);
    }

    public void setCallCoordinator(String port_name, String home_alias) {
        String uid = this.the_component_base_uid_ + '/' + port_name + ':' + this.the_component_version_;
        this.call_coordinator_sh_.put((Object)uid, (Object)home_alias);
    }

    public void setCallCoordinatorConfig(String port_name, PropertySet config) {
        String uid = this.the_component_base_uid_ + '/' + port_name + ':' + this.the_component_version_;
        this.call_coordinator_ps_.put((Object)uid, (Object)config);
    }

    public void setCallControllers(String port_name, String[] homes_alias) {
        String uid = this.the_component_base_uid_ + '/' + port_name + ':' + this.the_component_version_;
        this.call_controllers_sh_.put((Object)uid, (Object)homes_alias);
    }

    public void setCallControllersConfig(String port_name, PropertySet[] configs) {
        String uid = this.the_component_base_uid_ + '/' + port_name + ':' + this.the_component_version_;
        this.call_controllers_ps_.put((Object)uid, (Object)configs);
    }

    public void setActCoordinator(String port_name, String home_alias) {
        String uid = this.the_component_base_uid_ + '/' + port_name + ':' + this.the_component_version_;
        this.act_coordinator_sh_.put((Object)uid, (Object)home_alias);
    }

    public void setActCoordinatorConfig(String port_name, PropertySet config) {
        String uid = this.the_component_base_uid_ + '/' + port_name + ':' + this.the_component_version_;
        this.act_coordinator_ps_.put((Object)uid, (Object)config);
    }

    public void setActControllers(String port_name, String[] homes_alias) {
        String uid = this.the_component_base_uid_ + '/' + port_name + ':' + this.the_component_version_;
        this.act_controllers_sh_.put((Object)uid, (Object)homes_alias);
    }

    public void setActControllersConfig(String port_name, PropertySet[] configs) {
        String uid = this.the_component_base_uid_ + '/' + port_name + ':' + this.the_component_version_;
        this.act_controllers_ps_.put((Object)uid, (Object)configs);
    }

    public void setPCAPolicies(String[] policies) {
        this.policies_ = policies;
    }

    public CallCoordinator create_call_coordinator(String uid, String op_name, SystemHomeFinder finder) {
        String home_alias = null;
        PropertySet config = null;
        home_alias = this.getCallCoordinatorSystemHome(uid);
        config = this.getCallCoordinatorPropertySet(uid);
        if (home_alias == null && this.parent_configuration_ != null) {
            return this.parent_configuration_.create_call_coordinator(uid, op_name, finder);
        }
        if (home_alias == null) {
            home_alias = "EmptyCoordinatorHome";
        }
        try {
            SystemHome home = null;
            CallCoordinator result = null;
            home = finder.find_system_home(home_alias);
            result = (CallCoordinator)home.create_component(config);
            result.configure(config);
            return result;
        }
        catch (HomeNotFound ex) {
            throw new Error("System home : " + home_alias + " was not found");
        }
        catch (CreationFailed ex) {
            throw new Error("Creation of system component for system home : " + home_alias + " failed");
        }
        catch (ConfigurationFailed ex) {
            throw new Error("Configuration of system component for system home : " + home_alias + " failed");
        }
    }

    public CallController[] create_call_controllers(String uid, String op_name, SystemHomeFinder finder) {
        CallController[] result = null;
        String[] homes_alias = null;
        PropertySet[] configs = null;
        homes_alias = this.getCallControllersSystemHome(uid);
        configs = this.getCallControllersPropertySet(uid);
        if (homes_alias == null && this.parent_configuration_ != null) {
            return this.parent_configuration_.create_call_controllers(uid, op_name, finder);
        }
        if (homes_alias == null) {
            homes_alias = new String[]{"EmptyControllerHome"};
            configs = new PropertySet[]{null};
        }
        int i = 0;
        try {
            result = new CallController[homes_alias.length];
            SystemHome home = null;
            while (i < homes_alias.length) {
                home = finder.find_system_home(homes_alias[i]);
                result[i] = (CallController)home.create_component(configs[i]);
                result[i].configure(configs[i]);
                ++i;
            }
            if (this.parent_configuration_ != null) {
                CallController[] tmp1 = null;
                CallController[] tmp2 = null;
                tmp1 = this.parent_configuration_.create_call_controllers(uid, op_name, finder);
                if (tmp1 != null) {
                    int l = tmp1.length + result.length;
                    tmp2 = new CallController[l];
                    System.arraycopy(result, 0, tmp2, 0, result.length);
                    System.arraycopy(tmp1, 0, tmp2, result.length, tmp1.length);
                    return tmp2;
                }
            }
            return result;
        }
        catch (HomeNotFound ex) {
            throw new Error("System home :" + homes_alias[i] + " was not found");
        }
        catch (CreationFailed ex) {
            throw new Error("Creation of system component for system home :" + homes_alias[i] + " failed");
        }
        catch (ConfigurationFailed ex) {
            throw new Error("Configuration of system component for system home :" + homes_alias[i] + " failed");
        }
    }

    public ActivationCoordinator create_activation_coordinator(String uid, SystemHomeFinder finder) {
        String home_alias = null;
        PropertySet config = null;
        home_alias = this.getActCoordinatorSystemHome(uid);
        config = this.getActCoordinatorPropertySet(uid);
        if (home_alias == null && this.parent_configuration_ != null) {
            return this.parent_configuration_.create_activation_coordinator(uid, finder);
        }
        if (home_alias == null) {
            throw new Error("Can't use an empty coordinator for activation");
        }
        try {
            SystemHome home = null;
            ActivationCoordinator result = null;
            home = finder.find_system_home(home_alias);
            result = (ActivationCoordinator)home.create_component(config);
            result.configure(config);
            return result;
        }
        catch (HomeNotFound ex) {
            throw new Error("System home : " + home_alias + " was not found");
        }
        catch (CreationFailed ex) {
            throw new Error("Creation of system component for system home : " + home_alias + " failed");
        }
        catch (ConfigurationFailed ex) {
            throw new Error("Configuration of system component for system home : " + home_alias + " failed");
        }
    }

    public ActivationController[] create_activation_controllers(String uid, SystemHomeFinder finder) {
        ActivationController[] result = null;
        Object tmp = null;
        String[] homes_alias = null;
        PropertySet[] configs = null;
        homes_alias = this.getActControllersSystemHome(uid);
        configs = this.getActControllersPropertySet(uid);
        if (homes_alias == null && this.parent_configuration_ != null) {
            return this.parent_configuration_.create_activation_controllers(uid, finder);
        }
        if (homes_alias == null) {
            throw new Error("Can't use an empty controller for activation");
        }
        int i = 0;
        try {
            result = new ActivationController[homes_alias.length];
            SystemHome home = null;
            while (i < homes_alias.length) {
                home = finder.find_system_home(homes_alias[i]);
                result[i] = (ActivationController)home.create_component(configs[i]);
                result[i].configure(configs[i]);
                ++i;
            }
            if (this.parent_configuration_ != null) {
                ActivationController[] tmp1 = null;
                ActivationController[] tmp2 = null;
                tmp1 = this.parent_configuration_.create_activation_controllers(uid, finder);
                if (tmp1 != null) {
                    int l = tmp1.length + result.length;
                    tmp2 = new ActivationController[l];
                    System.arraycopy(result, 0, tmp2, 0, result.length);
                    System.arraycopy(tmp1, 0, tmp2, result.length, tmp1.length);
                    return tmp2;
                }
            }
            return result;
        }
        catch (HomeNotFound ex) {
            throw new Error("System home :" + homes_alias[i] + " was not found");
        }
        catch (CreationFailed ex) {
            throw new Error("Creation of system component for system home :" + homes_alias[i] + " failed");
        }
        catch (ConfigurationFailed ex) {
            throw new Error("Configuration of system component for system home :" + homes_alias[i] + " failed");
        }
    }

    public PCAPolicy[] create_PCAPolicies(String uid, SystemHomeFinder finder) {
        PCAPolicy[] result = null;
        String[] homes_alias = null;
        homes_alias = this.getPCAPolicies();
        int i = 0;
        try {
            result = new PCAPolicy[homes_alias.length];
            SystemHome home = null;
            while (i < homes_alias.length) {
                home = finder.find_system_home(homes_alias[i]);
                result[i] = (PCAPolicy)home.create_component(null);
                result[i].configure(null);
                ++i;
            }
        }
        catch (HomeNotFound ex) {
            throw new Error("System home :" + homes_alias[i] + " was not found");
        }
        catch (CreationFailed ex) {
            throw new Error("Creation of system component for system home :" + homes_alias[i] + " failed");
        }
        catch (ConfigurationFailed ex) {
            throw new Error("Configuration of system component for system home :" + homes_alias[i] + " failed");
        }
        if (result.length == 0 && this.parent_configuration_ != null) {
            return this.parent_configuration_.create_PCAPolicies(uid, finder);
        }
        if (result.length == 0) {
            return new PCAPolicy[0];
        }
        return result;
    }

    public void set_parent_configuration(SystemConfiguration config) {
        this.parent_configuration_ = config;
    }

    public void configure(PropertySet config) throws ConfigurationFailed {
        throw new ConfigurationFailed("not implemented !");
    }
}

