# ====================================================================
#
# OpenCCM: The Open CORBA Component Model Platform
# Copyright (C) 2000-2002 USTL - LIFL - GOAL
# Contact: openccm-team@objectweb.org
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
# USA
#
# Initial developer(s): Philippe Merle, Vadet Mathieu.
# Contributor(s): Sylvain Leblanc_______________________.
#
# ====================================================================
#
#  OMG IDLscript for demo1.
#
#  Note: To do before starting this script
#    ir_load demo1.idl
#
# ====================================================================

println("Obtaining the Name Service...")

ns = CORBA.ORB.resolve_initial_references("NameService")

# ====================================================================

println("Obtaining the Java Component Servers...")

server1 = ns.resolve([["ComponentServer1",""]])
server2 = ns.resolve([["ComponentServer2",""]])

server1_cs = server1.provide_component_server()
server1_inst = server1.provide_install()

server2_cs = server2.provide_component_server()
server2_inst = server2.provide_install()

# ====================================================================

println("Installing archives...")

server1_inst.install("demo1", "./archives/demo1.jar")
server2_inst.install("demo1", "./archives/demo1.jar")

server1_inst.install("openccm_plugins", "./OpenCCM_Plugins.jar")
server2_inst.install("openccm_plugins", "./OpenCCM_Plugins.jar")

# ====================================================================

println("Creating containers...")

server1_cont = server1_cs.create_container([]);
server2_cont = server2_cs.create_container([]);

# ====================================================================

println("Instantiating homes...")

ch = server1_cont.install_home("demo1", "org.objectweb.ccm.demo1.ClientHomeImpl.create_home", [])
sh = server2_cont.install_home("demo1", "org.objectweb.ccm.demo1.ServerHomeImpl.create_home", [])

# ====================================================================

println("Instantiating components...")

c1 = ch.create()
c2 = ch.create()
c3 = ch.create()
s = sh.create()

# ====================================================================

println("Configuring components...")

c1.the_name = "Mathieu"
c2.the_name = "Raphael"
c3.the_name = "Philippe"
s.the_name = "The Server"

# ====================================================================

println("Interconnecting components...")

for_clients = s.provide_for_clients()
c1.connect_to_server(for_clients)
c2.connect_to_server(for_clients)
c3.connect_to_server(for_clients)

# ====================================================================

println("Configuration completion...")

s.configuration_complete()
c1.configuration_complete()
c2.configuration_complete()
c3.configuration_complete()

# ====================================================================
