#!/bin/sh
# ====================================================================
#
# OpenCCM: The Open CORBA Component Model Platform
# Copyright (C) 2000-2002 USTL - LIFL - GOAL
# Contact: openccm-team@objectweb.org
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
# USA
#
# Initial developer(s): Romain Rouvoy.
# Contributor(s): ____________________________________________________.
#
# ====================================================================
#
#  Starting Ant Compilation Process
#
# ====================================================================


#
# Set up the environment
#
if [ -z "$JAVA_HOME" ] ; then
  JAVAC=`which java`
  if [ -z "$JAVAC" ] ; then
    echo "Cannot find JAVA. Please set your PATH."
    exit 1
  fi
  JAVA_BIN=`dirname $JAVAC`
  JAVA_HOME=$JAVA_BIN/..
fi

JAVAC=$JAVA_HOME/bin/java

PS=':'
if [ $OSTYPE = "cygwin32" ] || [ $OSTYPE = "cygwin" ] ; then
    PS=';'
fi

#
# Concatenate all the libraries in the externals/antdirectory and append
# it to the classpath environment variable
#
CLASSPATH=`echo /home/deng/dev-java/OpenCCM-0.5/externals/ant/*.jar | tr ' ' ${PS}`${PS}$CLASSPATH
CLASSPATH=$JAVA_HOME/lib/tools.jar${PS}/home/deng/dev-java/OpenCCM-0.5/externals/xerces.jar${PS}$CLASSPATH

#
# Execute the build tool passing the build.xml file
#
$JAVAC -cp $CLASSPATH -Dant.home=/home/deng/dev-java/OpenCCM-0.5/externals/ant org.apache.tools.ant.Main "$@" -buildfile build.xml



