/*====================================================================

This file was produced by the OpenCCM ir3_java generator.

OpenCCM: The Open CORBA Component Model Platform
Copyright (C) 2000-2002 USTL - LIFL - GOAL
Contact: openccm-team@objectweb.org

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
USA

Initial developer(s): Mathieu Vadet.
Contributor(s): Philippe Merle.

====================================================================*/

package cadena.common;

/**
 * Monolithic executor wrapper class for ::common::BMPushDataSource
 *
 * Wrap monolithic executors as executor locators.
 */
public class BMPushDataSourceMonolithicWrapper
     extends org.objectweb.ccm.Components.MonolithicWrapperBase
{
    // ==================================================================
    //
    // Internal State.
    //
    // ===================================================================
    
    /** Reference to the wrapped monolithic executor instance. */
    protected CCM_BMPushDataSource _monolithic_executor;
    
    /** Wrapper for port timeOut. */
    protected timeOut_ConsumerWrapper timeOut_wrapper_ =
        new timeOut_ConsumerWrapper();


    // ==================================================================
    //
    // Constructor.
    //
    // ===================================================================
    
    /**
     * The default constructor.
     *
     * @param executor The monolithic executor instance to wrap.
     */
    public
    BMPushDataSourceMonolithicWrapper(org.omg.Components.EnterpriseComponent executor)
    {
        _monolithic_executor = (CCM_BMPushDataSource)executor;
    }
    
    // ==================================================================
    //
    // Internal methods.
    //
    // ===================================================================
    
    // ==================================================================
    //
    // Public methods for OMG IDL ::Components::ExecutorLocator
    //
    // ==================================================================
    
    //
    //  IDL:omg.org/Components/ExecutorLocator/obtain_executor:1.0
    //
    /**
     * Obtain an executor.
     *
     * @param name The executor name.
     * @return The executor reference.
     * @exception org.omg.Components.CCMException Thrown if any error.
     */
    public org.omg.CORBA.Object
    obtain_executor(java.lang.String name)
    throws org.omg.Components.CCMException
    {
        getLogger().trace(this, "Obtaining executor " + name);
        
        if (name.equals("BMPushDataSource"))
            return _monolithic_executor;
        
        if (name.equals("timeOut"))
            return timeOut_wrapper_;
        
        getLogger().error(this, "Executor " + name + " not found");
        throw new org.omg.Components.CCMException();
    }
    
    //
    // IDL:omg.org/Components/ExecutorLocator/release_executor:1.0
    //
    /**
     * Release an executor.
     *
     * @param executor The executor reference.
     * @exception org.omg.Components.CCMException Thrown if any error.
     */
    public void
    release_executor(org.omg.CORBA.Object executor)
    throws org.omg.Components.CCMException
    {
        getLogger().trace(this, "Releasing executor " + executor);
    }
    
    // ==================================================================
    //
    // Wrapper classes for event sinks.
    //
    // ==================================================================
    
    /**
     * Internal wrapper class for OMG IDL CCM_TimeOutConsumer
     */
    class timeOut_ConsumerWrapper
    extends org.objectweb.corba.util.LocalObjectBase
    implements cadena.common.CCM_TimeOutConsumer
    {
        //
        // IDL:cadena/common/CCM_TimeOutConsumer/push:1.0
        //
        /**
         * Wrap OMG IDL ::common::CCM_TimeOutConsumer::push.
         */
        public void
        push(cadena.common.TimeOut event)
        {
            _monolithic_executor.push_timeOut(event);
        }
    }
    
}
