package cadena.modalsp;

public class Scenario{
	public static void main(String[] args) throws Exception {
		org.omg.Components.CCMHome ccmhome;
		// Init the ORB.
		System.out.println("Initializing the ORB...");
		// Init the OpenCCM Components Runtime.
		org.omg.CORBA.ORB corbaorb = org.objectweb.ccm.Components.Runtime.init(args);

		// Obtain the Name Service.
		System.out.println("Obtaining the Name Service...");
		org.omg.CORBA.Object corbaobj = corbaorb.resolve_initial_references("NameService");
		org.omg.CosNaming.NamingContext namingContext = org.omg.CosNaming.NamingContextHelper.narrow(corbaobj);

		// Obtain the component servers.
		System.out.println("Obtaining Component Servers...");
		org.omg.CosNaming.NameComponent[] nameComponent = new org.omg.CosNaming.NameComponent[1];
		nameComponent[0] = new org.omg.CosNaming.NameComponent("ComponentServer1","");
		corbaobj = namingContext.resolve(nameComponent);
		org.objectweb.ccm.Deployment.Server componentserver1_server =
		org.objectweb.ccm.Deployment.ServerHelper.narrow(corbaobj);
		nameComponent[0].id = "ComponentServer2";
		corbaobj = namingContext.resolve(nameComponent);
		org.objectweb.ccm.Deployment.Server componentserver2_server = 
		org.objectweb.ccm.Deployment.ServerHelper.narrow(corbaobj);

		// Obtain the container homes.
		org.omg.Components.Deployment.ComponentServer componentserver1_cs = 
		componentserver1_server.provide_component_server();
		org.omg.Components.Deployment.ComponentServer componentserver2_cs = 
		componentserver2_server.provide_component_server();

		//Install archives.
		System.out.println("Installing archives...");
		org.omg.Components.Deployment.ComponentInstallation componentserver1_inst = 
		componentserver1_server.provide_install();
		org.omg.Components.Deployment.ComponentInstallation componentserver2_inst = 
		componentserver2_server.provide_install();
		componentserver1_inst.install("modalsp", "./archives/modalsp.jar");
		componentserver2_inst.install("modalsp", "./archives/modalsp.jar");
		componentserver1_inst.install("openccm_plugins", "./OpenCCM_Plugins.jar");
		componentserver2_inst.install("openccm_plugins", "./OpenCCM_Plugins.jar");

		org.omg.Components.Deployment.Container componentserver1_cont =
			componentserver1_cs.create_container(new org.omg.Components.ConfigValue[0]);

		org.omg.Components.Deployment.Container componentserver2_cont =
			componentserver2_cs.create_container(new org.omg.Components.ConfigValue[0]);

		System.out.println("Instantiating homes, components...");
		ccmhome = componentserver1_cont.install_home("modalsp", "cadena.common.EventChannelHomeImpl.create_home",
 		new org.omg.Components.ConfigValue[0]);
		cadena.common.EventChannelHome eventchannelComponentServer1Home = cadena.common.EventChannelHomeHelper.narrow(ccmhome);
		cadena.common.EventChannel eventchannel = eventchannelComponentServer1Home.create();
		ccmhome = componentserver2_cont.install_home("modalsp", "cadena.common.BMDeviceHomeImpl.create_home",
 		new org.omg.Components.ConfigValue[0]);
		cadena.common.BMDeviceHome bmdeviceComponentServer2Home = cadena.common.BMDeviceHomeHelper.narrow(ccmhome);
		cadena.common.BMDevice gps = bmdeviceComponentServer2Home.create();
		ccmhome = componentserver2_cont.install_home("modalsp", "cadena.common.BMLazyActiveHomeImpl.create_home",
 		new org.omg.Components.ConfigValue[0]);
		cadena.common.BMLazyActiveHome bmlazyactiveComponentServer2Home = cadena.common.BMLazyActiveHomeHelper.narrow(ccmhome);
		cadena.common.BMLazyActive airframe = bmlazyactiveComponentServer2Home.create();
		ccmhome = componentserver2_cont.install_home("modalsp", "cadena.modalsp.BMDisplayThreeCorrelationHomeImpl.create_home",
 		new org.omg.Components.ConfigValue[0]);
		cadena.modalsp.BMDisplayThreeCorrelationHome bmdisplaythreecorrelationComponentServer2Home = cadena.modalsp.BMDisplayThreeCorrelationHomeHelper.narrow(ccmhome);
		cadena.modalsp.BMDisplayThreeCorrelation navdisplay = bmdisplaythreecorrelationComponentServer2Home.create();
		ccmhome = componentserver2_cont.install_home("modalsp", "cadena.common.BMModeSourceHomeImpl.create_home",
 		new org.omg.Components.ConfigValue[0]);
		cadena.common.BMModeSourceHome bmmodesourceComponentServer2Home = cadena.common.BMModeSourceHomeHelper.narrow(ccmhome);
		cadena.common.BMModeSource pilotcontrol = bmmodesourceComponentServer2Home.create();
		ccmhome = componentserver2_cont.install_home("modalsp", "cadena.modalsp.BMModalTwoOrCorrelationHomeImpl.create_home",
 		new org.omg.Components.ConfigValue[0]);
		cadena.modalsp.BMModalTwoOrCorrelationHome bmmodaltwoorcorrelationComponentServer2Home = cadena.modalsp.BMModalTwoOrCorrelationHomeHelper.narrow(ccmhome);
		//cadena.modalsp.BMModalTwoOrCorrelation navsteering = bmmodaltwoorcorrelationComponentServer2Home.create();
		cadena.modalsp.BMModalTwoOrCorrelation navsteering = bmmodaltwoorcorrelationComponentServer2Home._new(cadena.common.OnOffMode.enabled);
		ccmhome = componentserver2_cont.install_home("modalsp", "cadena.common.BMModalHomeImpl.create_home",
 		new org.omg.Components.ConfigValue[0]);
		cadena.common.BMModalHome bmmodalComponentServer2Home = cadena.common.BMModalHomeHelper.narrow(ccmhome);
		cadena.common.BMModal tacticalsteering = bmmodalComponentServer2Home.create();
		ccmhome = componentserver2_cont.install_home("modalsp", "cadena.common.BMPushDataSourceHomeImpl.create_home",
 		new org.omg.Components.ConfigValue[0]);
		cadena.common.BMPushDataSourceHome bmpushdatasourceComponentServer2Home = cadena.common.BMPushDataSourceHomeHelper.narrow(ccmhome);
		cadena.common.BMPushDataSource navigator = bmpushdatasourceComponentServer2Home.create();
		ccmhome = componentserver2_cont.install_home("modalsp", "cadena.common.BMPassiveHomeImpl.create_home",
 		new org.omg.Components.ConfigValue[0]);
		cadena.common.BMPassiveHome bmpassiveComponentServer2Home = cadena.common.BMPassiveHomeHelper.narrow(ccmhome);
		cadena.common.BMPassive navsteeringpoints = bmpassiveComponentServer2Home.create();

		System.out.println("set instance names...");
		eventchannel.name("EventChannel");
		gps.name("GPS");
		airframe.name("AirFrame");
		navdisplay.name("NavDisplay");
		pilotcontrol.name("PilotControl");
		navsteering.name("NavSteering");
		tacticalsteering.name("TacticalSteering");
		navigator.name("Navigator");
		navsteeringpoints.name("NavSteeringPoints");

		System.out.println("Interconnecting components...");
		eventchannel.subscribe_timeOut5(navigator.get_consumer_timeOut());
		eventchannel.subscribe_timeOut1(pilotcontrol.get_consumer_timeOut());
		eventchannel.subscribe_timeOut20(gps.get_consumer_timeOut());
		gps.subscribe_outDataAvailable(airframe.get_consumer_inDataAvailable());
		airframe.connect_dataIn(gps.provide_dataOut());
		navdisplay.connect_dataIn1(airframe.provide_dataOut());
		airframe.subscribe_outDataAvailable(navsteering.get_consumer_inDataAvailableAirFrame());
		navsteering.connect_dataIn2(airframe.provide_dataOut());
		airframe.subscribe_outDataAvailable(tacticalsteering.get_consumer_inDataAvailable());
		tacticalsteering.connect_dataIn(airframe.provide_dataOut());
		pilotcontrol.connect_modeToggle2(navsteering.provide_modeChange());
		navdisplay.connect_dataIn3(navsteering.provide_dataOut());
		navdisplay.connect_dataIn2(tacticalsteering.provide_dataOut());
		pilotcontrol.connect_modeToggle1(tacticalsteering.provide_modeChange());
		navigator.connect_dataWriteOut(navsteeringpoints.provide_dataWriteIn());
		navsteering.connect_dataIn1(navsteeringpoints.provide_dataOut());
		navsteeringpoints.subscribe_outDataAvailable(navsteering.get_consumer_inDataAvailableNavSteeringPoints());

		System.out.println("Components configuration completion...");
		eventchannel.configuration_complete();
		gps.configuration_complete();
		airframe.configuration_complete();
		navdisplay.configuration_complete();
		pilotcontrol.configuration_complete();
		navsteering.configuration_complete();
		tacticalsteering.configuration_complete();
		navigator.configuration_complete();
		navsteeringpoints.configuration_complete();
		System.exit(0);
	}
}
